<?php
// app/config/config.php

define('APP_NAME', 'B & F Facility Management System');

// Debug (set to false in production)
define('APP_DEBUG', true);

// Session
define('SESSION_NAME', 'rental_inspect_sess');

// Error reporting
if (APP_DEBUG) {
  ini_set('display_errors', '1');
  ini_set('display_startup_errors', '1');
  error_reporting(E_ALL);
} else {
  ini_set('display_errors', '0');
  ini_set('display_startup_errors', '0');
}

// Timezone
date_default_timezone_set('Asia/Manila');

// Base URL detection:
// - If environment variable BASE_URL is set, it will be used.
// - Otherwise auto-detect from the request (works on cPanel when docroot is /public).
$__envBase = getenv('BASE_URL');
if ($__envBase) {
  $base = rtrim($__envBase, '/');
} else {
  $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
          || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443');
  $scheme = $isHttps ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';

  $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
  $dir = str_replace('\\', '/', dirname($scriptName));
  $dir = rtrim($dir, '/');

  // Example:
  // - If your docroot is .../public, and you open /login.php, dirname is "/" => base is "https://domain"
  // - If installed in subfolder, dirname is "/subfolder" => base is "https://domain/subfolder"
  $base = $scheme . '://' . $host . ($dir === '' || $dir === '/' ? '' : $dir);
}
define('BASE_URL', $base);

// Upload settings
define('MAX_UPLOAD_MB', 8);
define('MAX_UPLOAD_BYTES', MAX_UPLOAD_MB * 1024 * 1024);

define('ALLOWED_IMAGE_MIME', [
  'image/jpeg',
  'image/png',
  'image/webp',
]);

// Absolute upload folders (saved on disk)
define('UPLOAD_BASE_DIR', realpath(__DIR__ . '/../../public') . DIRECTORY_SEPARATOR . 'uploads');
define('UPLOAD_BEFORE_DIR', UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'before');
define('UPLOAD_AFTER_DIR',  UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'after');
