<?php
require_once __DIR__ . '/../config/db.php';

class InventoryItem
{
    public static function listByUnit(int $unitId): array
    {
        $stmt = db()->prepare("SELECT * FROM inventory_items WHERE unit_id = ? ORDER BY item_name ASC");
        $stmt->execute([$unitId]);
        return $stmt->fetchAll();
    }

    public static function create(int $unitId, string $name, int $qty, string $condition, string $remarks = ''): void
    {
        $stmt = db()->prepare("
            INSERT INTO inventory_items (unit_id, item_name, quantity, item_condition, remarks)
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$unitId, $name, $qty, $condition, $remarks]);
    }

    public static function delete(int $id): void
    {
        $stmt = db()->prepare("DELETE FROM inventory_items WHERE id = ?");
        $stmt->execute([$id]);
    }
}
