<?php
require_once __DIR__ . '/app/config/config.php';
require_once __DIR__ . '/app/middleware/auth.php';
require_once __DIR__ . '/app/models/User.php';

require_login();
if ($_SESSION['user']['role'] !== 'admin') {
    http_response_code(403);
    exit('Forbidden');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    try {
        if ($action === 'create') {
            $full = trim($_POST['full_name'] ?? '');
            $email = trim($_POST['email'] ?? '');
            $pass = $_POST['password'] ?? '';
            $role = $_POST['role'] ?? 'staff';

            if ($full === '' || $email === '' || $pass === '') {
                $error = "All fields are required.";
            } else {
                User::create($full, $email, $pass, $role);
                $success = "User created successfully.";
            }
        }

        if ($action === 'toggle_active') {
            $id = (int)($_POST['id'] ?? 0);
            $active = (int)($_POST['active'] ?? 0);
            if ($id) {
                User::setActive($id, $active);
                $success = "User updated.";
            }
        }

        if ($action === 'delete') {
            $id = (int)($_POST['id'] ?? 0);
            if ($id) {
                User::delete($id);
                $success = "User deleted.";
            }
        }

    } catch (Throwable $e) {
        // common: duplicate email
        $error = $e->getMessage();
    }
}

$users = User::all();

$pageTitle = 'Manage Users';
require_once __DIR__ . '/app/views/partials/header.php';
?>

<div class="mb-3">
  <a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/dashboard.php">← Back to Dashboard</a>
</div>


<div class="row">
  <div class="col-lg-5">
    <div class="card p-4 mb-4">
      <h5 class="page-title mb-3">Add User</h5>

      <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
      <?php endif; ?>

      <form method="post">
        <input type="hidden" name="action" value="create">

        <div class="mb-3">
          <label class="form-label">Full Name</label>
          <input name="full_name" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Email</label>
          <input name="email" type="email" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Password</label>
          <input name="password" type="password" class="form-control" required>
        </div>

        <div class="mb-4">
          <label class="form-label">Role</label>
          <select name="role" class="form-select">
            <option value="staff">Staff</option>
            <option value="admin">Admin</option>
          </select>
        </div>

        <button class="btn btn-primary w-100">Create User</button>
remember to change password later after login
      </form>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-4">
      <h5 class="page-title mb-3">Users List</h5>

      <div class="table-responsive">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>Name</th>
              <th>Email</th>
              <th>Role</th>
              <th>Status</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($users as $u): ?>
              <tr>
                <td><?= htmlspecialchars($u['full_name']) ?></td>
                <td><?= htmlspecialchars($u['email']) ?></td>
                <td><span class="badge badge-soft"><?= htmlspecialchars($u['role']) ?></span></td>
                <td>
                  <?php if ((int)$u['is_active'] === 1): ?>
                    <span class="badge text-bg-success">Active</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">Inactive</span>
                  <?php endif; ?>
                </td>
                <td class="text-end">

                  <form method="post" class="d-inline">
                    <input type="hidden" name="action" value="toggle_active">
                    <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                    <input type="hidden" name="active" value="<?= ((int)$u['is_active'] === 1) ? 0 : 1 ?>">
                    <button class="btn btn-sm btn-outline-primary">
                      <?= ((int)$u['is_active'] === 1) ? 'Deactivate' : 'Activate' ?>
                    </button>
                  </form>

                  <form method="post" class="d-inline" onsubmit="return confirm('Delete this user?');">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                    <button class="btn btn-sm btn-outline-danger">Delete</button>
                  </form>

                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<?php require_once __DIR__ . '/app/views/partials/footer.php'; ?>
