<?php
// app/config/config.php

// ---------------------------------------------------------
// PHP 7.4 compatibility polyfills (required on many cPanels)
// ---------------------------------------------------------
if (!function_exists('str_starts_with')) {
  function str_starts_with($haystack, $needle) {
    return $needle === '' || strpos($haystack, $needle) === 0;
  }
}
if (!function_exists('str_contains')) {
  function str_contains($haystack, $needle) {
    return $needle !== '' && strpos($haystack, $needle) !== false;
  }
}

// ---------------------------------------------------------
// App basics
// ---------------------------------------------------------
define('APP_NAME', 'B & F Facility Management System');

// Auto-detect BASE_URL (works on addon domains/subdomains)
// Example: https://bubbleandfoldfms.app
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'localhost';
$base   = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? '/'), '/\\');
$base   = ($base === '/' ? '' : $base);

define('BASE_URL', $scheme . '://' . $host . $base);

// Session
define('SESSION_NAME', 'rental_inspect_sess');

// Debug (set false on production)
define('APP_DEBUG', false);

// Upload settings (for inspection photos)
define('MAX_UPLOAD_MB', 8);
define('MAX_UPLOAD_BYTES', MAX_UPLOAD_MB * 1024 * 1024);

define('ALLOWED_IMAGE_MIME', [
  'image/jpeg',
  'image/png',
  'image/webp',
]);

// Absolute upload folders (saved on disk)
// Project root is 3 levels up from this file: app/config -> project root
$projectRoot = realpath(__DIR__ . '/../../..');
define('UPLOAD_BASE_DIR', $projectRoot . DIRECTORY_SEPARATOR . 'uploads');
define('UPLOAD_BEFORE_DIR', UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'before');
define('UPLOAD_AFTER_DIR',  UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'after');
