<?php
require_once __DIR__ . '/../config/config.php';

function start_session(): void
{
    if (session_status() === PHP_SESSION_NONE) {
        session_name(SESSION_NAME);
        session_start();
    }
}

function require_login(): void
{
    start_session();

    if (!isset($_SESSION['user'])) {
        $next = $_SERVER['REQUEST_URI'] ?? '/dashboard.php';
        header('Location: ' . BASE_URL . '/login.php?next=' . urlencode($next));
        exit;
    }
}

function current_user(): ?array
{
    start_session();
    return $_SESSION['user'] ?? null;
}
