<?php
// app/models/Notification.php
require_once __DIR__ . '/../config/db.php';

class Notification
{
  public static function unreadCount(int $userId): int
  {
    $stmt = db()->prepare("SELECT COUNT(*) AS c FROM notifications WHERE user_id=? AND is_read=0");
    $stmt->execute([$userId]);
    $row = $stmt->fetch();
    return (int)($row['c'] ?? 0);
  }

  public static function unreadList(int $userId, int $limit = 10): array
  {
    return self::listByUser($userId, $limit, true);
  }

  public static function listByUser(int $userId, int $limit = 200, bool $onlyUnread = false): array
  {
    $limit = max(1, min($limit, 1000));

    $where = "n.user_id=?";
    if ($onlyUnread) $where .= " AND n.is_read=0";

    $sql = "
      SELECT n.*, a.full_name AS actor_name
      FROM notifications n
      LEFT JOIN users a ON a.id = n.actor_user_id
      WHERE {$where}
      ORDER BY n.created_at DESC, n.id DESC
      LIMIT {$limit}
    ";

    $stmt = db()->prepare($sql);
    $stmt->execute([$userId]);
    return $stmt->fetchAll();
  }

  public static function markRead(int $userId, int $id): void
  {
    $stmt = db()->prepare("UPDATE notifications SET is_read=1 WHERE id=? AND user_id=?");
    $stmt->execute([$id, $userId]);
  }

  public static function markAllRead(int $userId): void
  {
    $stmt = db()->prepare("UPDATE notifications SET is_read=1 WHERE user_id=? AND is_read=0");
    $stmt->execute([$userId]);
  }

  // Sends to ALL active admins
  public static function notifyAdmins(string $type, string $title, string $body, string $linkUrl = '', ?int $actorUserId = null): void
  {
    $admins = db()->query("SELECT id FROM users WHERE role='admin' AND is_active=1")->fetchAll();
    $stmt = db()->prepare("
      INSERT INTO notifications (user_id, actor_user_id, type, title, body, link_url, is_read, created_at)
      VALUES (?, ?, ?, ?, ?, ?, 0, NOW())
    ");

    foreach ($admins as $a) {
      $stmt->execute([
        (int)$a['id'],
        $actorUserId,
        $type,
        $title,
        $body,
        $linkUrl
      ]);
    }
  }
}
