<?php
// app/views/partials/sidebar.php
// expects: $user (array) and optional $active (string)
$role = $user['role'] ?? 'staff';

function isActive($key, $active) {
  return ($active ?? '') === $key ? 'active' : '';
}
?>
<aside class="app-sidebar">
  <div class="sidebar-brand">
    <div class="brand-mark">BF</div>
    <div class="brand-text">
      <div class="brand-title">B & F</div>
      <div class="brand-sub">Facility System</div>
    </div>
  </div>

  <nav class="sidebar-nav">
    <a class="nav-item <?= isActive('dashboard', $active) ?>" href="<?= BASE_URL ?>/<?= $role === 'admin' ? 'dashboard.php' : 'staff_dashboard.php' ?>">
      <span class="ico">📊</span> Dashboard
    </a>

    <a class="nav-item <?= isActive('scan', $active) ?>" href="<?= BASE_URL ?>/scan_camera.php">
      <span class="ico">📷</span> Scan QR
    </a>

    <a class="nav-item <?= isActive('units', $active) ?>" href="<?= BASE_URL ?>/units_list.php">
      <span class="ico">🏢</span> Units
    </a>

    <div class="nav-group">
      <div class="nav-group-title">Laundry</div>
      <a class="nav-item <?= isActive('laundry_worklist', $active) ?>" href="<?= BASE_URL ?>/laundry_worklist.php">
        <span class="ico">🧺</span> Worklist
      </a>
      <a class="nav-item <?= isActive('laundry_schedule', $active) ?>" href="<?= BASE_URL ?>/laundry_today.php">
        <span class="ico">🗓️</span> Schedule
      </a>
      <a class="nav-item <?= isActive('laundry_lookup', $active) ?>" href="<?= BASE_URL ?>/laundry_lookup.php">
        <span class="ico">🔎</span> Bag/Unit Lookup
      </a>
    </div>

    <?php if ($role === 'admin'): ?>
      <div class="nav-group">
        <div class="nav-group-title">Admin</div>
        <a class="nav-item <?= isActive('users', $active) ?>" href="<?= BASE_URL ?>/admin_users.php"><span class="ico">🛡️</span> Users</a>
        <a class="nav-item <?= isActive('tenants', $active) ?>" href="<?= BASE_URL ?>/tenants_list.php"><span class="ico">👥</span> Tenants</a>
        <a class="nav-item <?= isActive('reports', $active) ?>" href="<?= BASE_URL ?>/reports.php"><span class="ico">📈</span> Reports</a>
        <a class="nav-item <?= isActive('audit', $active) ?>" href="<?= BASE_URL ?>/audit_logs.php"><span class="ico">🧾</span> Audit Logs</a>
      </div>
    <?php endif; ?>
  </nav>
</aside>
