<?php
require_once __DIR__ . '/app/config/config.php';

session_name(SESSION_NAME);
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}


// If already logged in, go directly to correct dashboard
if (!empty($_SESSION['user'])) {
  $role = $_SESSION['user']['role'] ?? '';
  if ($role === 'staff') {
    header('Location: ' . BASE_URL . '/staff_dashboard.php');
  } else {
    header('Location: ' . BASE_URL . '/dashboard.php');
  }
  exit;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= htmlspecialchars(APP_NAME) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" type="image/svg+xml" href="<?= BASE_URL ?>/assets/favicon/logo.svg">

  <link href="<?= BASE_URL ?>/assets/css/theme.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container vh-100 d-flex align-items-center justify-content-center">
  <div class="card shadow-sm p-5 text-center" style="max-width: 560px; width:100%;">
    <h3 class="mb-2"><?= htmlspecialchars(APP_NAME) ?></h3>

    <p class="text-muted mb-4">
      Manage unit inspections and laundry operations with a simple workflow for staff and admins.
    </p>

    <div class="d-grid gap-2">
      <a href="<?= BASE_URL ?>/login.php" class="btn btn-primary btn-lg">Login</a>
    </div>

    <hr class="my-4">

    <div class="text-muted small text-start">
      <div class="fw-semibold mb-2">What you can do:</div>
      <ul class="mb-0">
        <li>Scan unit QR codes to open a unit</li>
        <li>Upload multiple before/after photos for inspections</li>
        <li>Track laundry pickups, cleaning, and deliveries</li>
      </ul>
    </div>
  </div>
</div>

</body>
</html>
