<?php
require_once __DIR__ . '/app/config/config.php';

// ✅ Must use the same session name as login.php
session_name(SESSION_NAME);

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

// Clear session data
$_SESSION = [];

// Remove the session cookie (same name!)
if (ini_get('session.use_cookies')) {
  $params = session_get_cookie_params();

  setcookie(
    session_name(),
    '',
    time() - 42000,
    $params['path'] ?? '/',
    $params['domain'] ?? '',
    (bool)($params['secure'] ?? false),
    (bool)($params['httponly'] ?? true)
  );
}

// Destroy session
session_destroy();

// ✅ Go to welcome
header('Location: ' . BASE_URL . '/index.php?logged_out=1');
exit;
