<?php
require_once __DIR__ . '/../config/db.php';

class User
{
    public static function all(): array
    {
        $stmt = db()->query("SELECT id, full_name, email, role, is_active, created_at
                             FROM users ORDER BY created_at DESC");
        return $stmt->fetchAll();
    }

    public static function create(string $fullName, string $email, string $password, string $role): void
    {
        $hash = password_hash($password, PASSWORD_DEFAULT);

        $stmt = db()->prepare("INSERT INTO users (full_name, email, password_hash, role, is_active)
                               VALUES (?, ?, ?, ?, 1)");
        $stmt->execute([$fullName, $email, $hash, $role]);
    }

    public static function setActive(int $id, int $active): void
    {
        $stmt = db()->prepare("UPDATE users SET is_active = ? WHERE id = ?");
        $stmt->execute([$active, $id]);
    }

    public static function delete(int $id): void
    {
        $stmt = db()->prepare("DELETE FROM users WHERE id = ?");
        $stmt->execute([$id]);
    }
}
