<?php
// app/helpers/ui.php
require_once __DIR__ . '/../config/config.php';

function is_active(string $path): bool {
  $uri = $_SERVER['REQUEST_URI'] ?? '';
  return str_contains($uri, $path);
}

function nav_items(array $user): array {
  $role = $user['role'] ?? 'staff';

  $common = [
    ['label' => 'Home', 'url' => BASE_URL . '/welcome.php', 'icon' => '🏠'],
    ['label' => 'Units', 'url' => BASE_URL . '/units_list.php', 'icon' => '🏢'],
    ['label' => 'Scan QR', 'url' => BASE_URL . '/scan_camera.php', 'icon' => '📷'],
    ['label' => 'Laundry', 'url' => BASE_URL . '/laundry.php', 'icon' => '🧺'],
    ['label' => 'Transactions', 'url' => BASE_URL . '/laundry_transactions.php', 'icon' => '🧾'],
  ];

  if ($role === 'admin') {
    return array_merge([
      ['label' => 'Dashboard', 'url' => BASE_URL . '/dashboard.php', 'icon' => '📊'],
      ['label' => 'Notifications', 'url' => BASE_URL . '/notifications.php', 'icon' => '🔔'],
      ['label' => 'Reports', 'url' => BASE_URL . '/reports.php', 'icon' => '📈'],
    ], $common, [
      ['label' => 'Tenants', 'url' => BASE_URL . '/tenants_list.php', 'icon' => '👥'],
      ['label' => 'Users', 'url' => BASE_URL . '/admin_users.php', 'icon' => '🛡️'],
      ['label' => 'Add Building', 'url' => BASE_URL . '/admin_add_building.php', 'icon' => '➕'],
      ['label' => 'Add Unit', 'url' => BASE_URL . '/admin_add_unit.php', 'icon' => '➕'],
      ['label' => 'Audit Logs', 'url' => BASE_URL . '/audit_logs.php', 'icon' => '🧠'],
    ]);
  }

  // staff
  return array_merge([
    ['label' => 'Staff Dashboard', 'url' => BASE_URL . '/staff_dashboard.php', 'icon' => '✅'],
  ], $common, [
    ['label' => 'Reports', 'url' => BASE_URL . '/reports.php', 'icon' => '📈'],
  ]);
}
