<?php
// app/views/partials/header.php

// Start PHP session safely
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

if (!isset($pageTitle)) $pageTitle = APP_NAME;

$user = $_SESSION['user'] ?? null;
$role = $user['role'] ?? null;

// Choose home link based on role
$home = ($role === 'staff')
  ? (BASE_URL . '/staff_dashboard.php')
  : (BASE_URL . '/dashboard.php');
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title><?= htmlspecialchars($pageTitle) ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" type="image/svg+xml" href="<?= BASE_URL ?>/assets/favicon/logo.svg">

  
  <link href="<?= BASE_URL ?>/assets/css/theme.css" rel="stylesheet">
</head>
<body>

<nav class="navbar navbar-expand-lg mb-4">
  <div class="container">
    <a class="navbar-brand fw-semibold text-white" href="<?= htmlspecialchars($home) ?>">
      <?= htmlspecialchars(APP_NAME) ?>
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topNav"
            aria-controls="topNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="topNav">
      <?php if ($user): ?>
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">

          <?php if ($role === 'staff'): ?>
            <!-- STAFF NAV -->
            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/staff_dashboard.php">Dashboard</a>
            </li>

            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/scan_camera.php">Scan QR</a>
            </li>

            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/units_list.php">Units</a>
            </li>

            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Laundry
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_worklist.php">Worklist</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_today.php">Schedule</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry.php">Bag/Unit Lookup</a></li>
              </ul>
            </li>

          <?php else: ?>
            <!-- ADMIN NAV -->
            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/dashboard.php">Dashboard</a>
            </li>

            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/units_list.php">Units</a>
            </li>

            <li class="nav-item">
              <a class="nav-link" href="<?= BASE_URL ?>/scan_camera.php">Scan QR</a>
            </li>

            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Laundry
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry.php">Laundry Dashboard</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_worklist.php">Worklist</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_today.php">Schedule</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_transactions_all.php">All Transactions</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/laundry_items.php">Item Types (CRUD)</a></li>
              </ul>
            </li>

            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Admin
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/admin_users.php">Users</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/admin_add_building.php">Add Building</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/admin_add_unit.php">Add Unit</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/tenants_list.php">Tenants</a></li>
                <li><a class="dropdown-item" href="<?= BASE_URL ?>/audit_logs.php">Audit Logs</a></li>
              </ul>
            </li>
          <?php endif; ?>

        </ul>

        <div class="d-flex align-items-center gap-2">
          <div class="text-white small d-none d-lg-block">
            <?= htmlspecialchars($user['full_name'] ?? '') ?>
            <span class="badge bg-light text-dark ms-1"><?= htmlspecialchars($role ?? '') ?></span>
          </div>
          <a href="<?= BASE_URL ?>/logout.php" class="btn btn-sm btn-light">Logout</a>
        </div>
      <?php else: ?>
        <!-- Not logged in: show nothing on right -->
      <?php endif; ?>
    </div>
  </div>
</nav>
