<?php
require_once __DIR__ . '/../app/config/config.php';
require_once __DIR__ . '/../app/middleware/auth.php';
require_once __DIR__ . '/../app/models/LaundryBag.php';

require_login();
$user = current_user();

$pageTitle = 'Laundry Management';
require_once __DIR__ . '/../app/views/partials/header.php';

$q = trim((string)($_GET['q'] ?? ''));
$building = trim((string)($_GET['building'] ?? ''));
$status = trim((string)($_GET['status'] ?? ''));

$filters = [
  'q' => $q,
  'building' => $building,
  'status' => $status,
];

$bags = LaundryBag::listDashboard($filters, 500);
$buildings = LaundryBag::listBuildingsWithBags();

$statusOptions = [
  '' => 'All statuses',
  'dirty' => 'Dirty',
  'picked_up' => 'Picked Up',
  'delivered' => 'Delivered',
  'clean' => 'Clean',
];
?>

<div class="container">
<a class="btn btn-outline-dark" href="<?= BASE_URL ?>/laundry_today.php">Schedule</a>
<a href="<?= BASE_URL ?>/laundry_worklist.php" class="btn btn-outline-dark w-100 mb-2">
  Laundry Worklist (Current Status)
</a>

<a href="<?= BASE_URL ?>/laundry_items.php" class="btn btn-outline-dark w-100 mb-2">
  Laundry Bag Items (CRUD)
</a>


  <div class="card p-4 mb-3">
    <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
      <div>
        <h5 class="page-title mb-1">Laundry Management</h5>
        <div class="text-muted">Separate laundry dashboard (still connected to Units).</div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-primary" href="<?= BASE_URL ?>/dashboard.php">Dashboard</a>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/laundry_transactions_all.php">All Transactions</a>
      </div>
    </div>
  </div>

  <div class="card p-4 mb-3">
    <form method="get" class="row g-2 align-items-end">
      <div class="col-md-5">
        <label class="form-label">Search (Unit or Bag #)</label>
        <input class="form-control" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="e.g. A-101 or 12345">
      </div>

      <div class="col-md-4">
        <label class="form-label">Building</label>
        <select class="form-select" name="building">
          <option value="">All buildings</option>
          <?php foreach ($buildings as $b): ?>
            <?php $bn = (string)($b['building_name'] ?? ''); ?>
            <option value="<?= htmlspecialchars($bn) ?>" <?= $bn === $building ? 'selected' : '' ?>>
              <?= htmlspecialchars($bn) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-3">
        <label class="form-label">Status contains</label>
        <select class="form-select" name="status">
          <?php foreach ($statusOptions as $val => $label): ?>
            <option value="<?= htmlspecialchars($val) ?>" <?= $val === $status ? 'selected' : '' ?>>
              <?= htmlspecialchars($label) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-12 d-flex gap-2 mt-2">
        <button class="btn btn-primary">Apply Filters</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/laundry.php">Reset</a>
      </div>
    </form>
  </div>

  <div class="card p-4">
    <?php if (!$bags): ?>
      <div class="text-muted">No laundry bags match your filters.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-striped align-middle">
          <thead>
            <tr>
              <th>Building</th>
              <th>Unit</th>
              <th>Bag #</th>
              <th>Items Summary</th>
              <th>Last Updated</th>
              <th style="width:340px;">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($bags as $b): ?>
              <tr>
                <td><?= htmlspecialchars($b['building_name'] ?? '') ?></td>
                <td>
                  <a href="<?= BASE_URL ?>/unit.php?id=<?= (int)$b['unit_id'] ?>">
                    <?= htmlspecialchars($b['unit_code'] ?? '') ?>
                  </a>
                </td>
                <td><strong><?= htmlspecialchars($b['bag_number'] ?? '') ?></strong></td>
                <td class="small text-muted">
                  <?= htmlspecialchars($b['items_summary'] ?: 'No items selected') ?>
                </td>
                <td><?= htmlspecialchars($b['updated_at'] ?? '') ?></td>
                <td>
                  <div class="d-flex gap-2 flex-wrap">
                    <a class="btn btn-sm btn-primary"
                       href="<?= BASE_URL ?>/laundry_bag.php?bag_id=<?= (int)$b['id'] ?>">
                      Manage Bag
                    </a>
                    <a class="btn btn-sm btn-outline-secondary"
                       href="<?= BASE_URL ?>/laundry_transactions.php?bag_id=<?= (int)$b['id'] ?>">
                      Transactions
                    </a>
                    <a class="btn btn-sm btn-outline-primary"
                       href="<?= BASE_URL ?>/unit.php?id=<?= (int)$b['unit_id'] ?>">
                      View Unit
                    </a>

                    
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>

</div>

<?php require_once __DIR__ . '/../app/views/partials/footer.php'; ?>
