<?php

// ---------------- Debug (temporary) ----------------
// Set DEBUG=1 in your environment (or in cPanel MultiPHP INI editor as an env var)
// to show PHP errors in the browser. Turn this OFF after you fix the issue.
if (getenv('DEBUG') === '1') {
  ini_set('display_errors', '1');
  ini_set('display_startup_errors', '1');
  error_reporting(E_ALL);
}
// app/config/config.php
// Compatible with PHP 7.4+

// ---------------- Polyfills (PHP 7.4) ----------------
if (!function_exists('str_starts_with')) {
  function str_starts_with(string $haystack, string $needle): bool {
    return $needle === '' || substr($haystack, 0, strlen($needle)) === $needle;
  }
}
if (!function_exists('str_ends_with')) {
  function str_ends_with(string $haystack, string $needle): bool {
    return $needle === '' || substr($haystack, -strlen($needle)) === $needle;
  }
}
if (!function_exists('str_contains')) {
  function str_contains(string $haystack, string $needle): bool {
    return $needle === '' || strpos($haystack, $needle) !== false;
  }
}

// ---------------- Base URL (path only) ----------------
// Example:
//  - if app is at https://example.com/ -> BASE_URL = ''
//  - if app is at https://example.com/fms -> BASE_URL = '/fms'
$scriptName = $_SERVER['SCRIPT_NAME'] ?? '/';
$basePath = rtrim(str_replace('\\', '/', dirname($scriptName)), '/');
if ($basePath === '/') $basePath = '';
define('BASE_URL', $basePath);

define('APP_NAME', 'B & F Facility Management System');

define('SESSION_NAME', 'rental_inspection_sess');

define('MAX_UPLOAD_MB', 8);
define('MAX_UPLOAD_BYTES', MAX_UPLOAD_MB * 1024 * 1024);
define('ALLOWED_IMAGE_MIME', ['image/jpeg', 'image/png', 'image/webp']);

// Upload storage (filesystem)
// cPanel deployments can vary:
// - If you uploaded the whole project, your domain root likely contains a /public folder.
// - If you instead uploaded only the contents of /public, then this project won't have a /public folder.
//
// We resolve a safe uploads directory for both cases.
$projectRoot = dirname(__DIR__, 2);
$publicDir = $projectRoot . DIRECTORY_SEPARATOR . 'public';
if (!is_dir($publicDir)) {
  // Fallback: treat project root as the public directory
  $publicDir = $projectRoot;
}

define('UPLOAD_BASE_DIR', rtrim($publicDir, '/\\') . DIRECTORY_SEPARATOR . 'uploads');
define('UPLOAD_BEFORE_DIR', UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'before');
define('UPLOAD_AFTER_DIR',  UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'after');
define('UPLOAD_INSPECTION_DIR', UPLOAD_BASE_DIR . DIRECTORY_SEPARATOR . 'inspection');

// ---------------- Database (edit for cPanel) ----------------
// On cPanel you MUST set these values to your DB credentials.
// If you prefer, you can move them into a separate untracked file.
define('DB_HOST', 'localhost');
define('DB_NAME', 'rental_inspection');
define('DB_USER', 'root');
define('DB_PASS', '');

define('DB_CHARSET', 'utf8mb4');
