<?php
require_once __DIR__ . '/../config/db.php';

class Building
{
    public static function all(): array
    {
        $stmt = db()->query("SELECT id, name FROM buildings ORDER BY name");
        return $stmt->fetchAll();
    }

    public static function create(string $name, string $address = '', string $notes = ''): void
    {
        $stmt = db()->prepare(
            "INSERT INTO buildings (name, address, notes) VALUES (?, ?, ?)"
        );
        $stmt->execute([$name, $address, $notes]);
    }
}
