<?php
require_once __DIR__ . '/../config/db.php';

class Tenant
{
    public static function listByUnit(int $unitId): array
    {
        $stmt = db()->prepare("SELECT * FROM tenants WHERE unit_id = ? ORDER BY is_active DESC, full_name ASC");
        $stmt->execute([$unitId]);
        return $stmt->fetchAll();
    }

    public static function create(int $unitId, string $fullName, string $phone = '', string $email = ''): void
    {
        $stmt = db()->prepare("INSERT INTO tenants (unit_id, full_name, phone, email, is_active) VALUES (?, ?, ?, ?, 1)");
        $stmt->execute([$unitId, $fullName, $phone, $email]);
    }

    public static function setActive(int $tenantId, int $active): void
    {
        $stmt = db()->prepare("UPDATE tenants SET is_active = ? WHERE id = ?");
        $stmt->execute([$active, $tenantId]);
    }

    public static function createWithUnit(int $unitId, string $fullName, string $phone = '', string $email = ''): void
    {
    $stmt = db()->prepare("INSERT INTO tenants (unit_id, full_name, phone, email, is_active)
                           VALUES (?, ?, ?, ?, 1)");
    $stmt->execute([$unitId, $fullName, $phone, $email]);
    }

}
