<?php
require_once __DIR__ . '/../app/config/config.php';
require_once __DIR__ . '/../app/middleware/auth.php';
require_once __DIR__ . '/../app/models/Notification.php';

require_login();
$user = current_user();

// Admin only
if (($user['role'] ?? '') !== 'admin') {
  http_response_code(403);
  exit('Forbidden');
}

$userId = (int)$user['id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!empty($_POST['all'])) {
    Notification::markAllRead($userId);
  } else {
    $id = (int)($_POST['id'] ?? 0);
    if ($id) Notification::markRead($userId, $id);
  }
}

$back = $_SERVER['HTTP_REFERER'] ?? (BASE_URL . '/dashboard.php');
header('Location: ' . $back);
exit;
