<?php
// public/barcode.php
require_once __DIR__ . '/../helpers/auth.php';
require_role(['admin', 'staff']);

require_once __DIR__ . '/../helpers/code128.php';

$sku = trim((string)($_GET['sku'] ?? ''));
if ($sku === '') {
    http_response_code(400);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Missing sku";
    exit;
}

// Defaults optimized for phone camera scanning
$height = (int)($_GET['h'] ?? 90);
$module = (int)($_GET['m'] ?? 3);
$quiet  = (int)($_GET['qz'] ?? 20);

if ($height < 40) $height = 40;
if ($height > 200) $height = 200;
if ($module < 2) $module = 2;      // keep bars thick
if ($module > 6) $module = 6;
if ($quiet < 10) $quiet = 10;
if ($quiet > 60) $quiet = 60;

try {
    $svg = code128_svg($sku, $height, $module, $quiet);
    header('Content-Type: image/svg+xml; charset=utf-8');
    echo $svg;
} catch (Throwable $e) {
    http_response_code(400);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Barcode error: " . $e->getMessage();
}
