<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role(['staff']);

$pdo = db();
$title = "Staff Dashboard - IMS";

// Quick stats
$stats = [];

// Products count
$stats['products'] = (int)$pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();

// Low stock count
$stats['low_stock'] = (int)$pdo->query("
  SELECT COUNT(*) FROM (
    SELECT p.id,
      (
        COALESCE(SUM(CASE WHEN m.movement_type='IN' THEN m.quantity ELSE 0 END),0)
        - COALESCE(SUM(CASE WHEN m.movement_type='OUT' THEN m.quantity ELSE 0 END),0)
        + COALESCE(SUM(CASE WHEN m.movement_type='ADJUST' THEN m.quantity ELSE 0 END),0)
      ) AS current_stock
    FROM products p
    LEFT JOIN inventory_movements m ON m.product_id = p.id
    GROUP BY p.id
    HAVING p.reorder_level > 0 AND current_stock <= p.reorder_level
  ) t
")->fetchColumn();

// Deliveries by status
$deliveryCounts = $pdo->query("
  SELECT status, COUNT(*) cnt
  FROM deliveries
  GROUP BY status
")->fetchAll();

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/sidebar.php';
?>

<main class="col-12 col-md-9 col-lg-10 p-3 p-md-4">
  <h4 class="mb-3">Staff Dashboard</h4>

  <div class="row g-3 mb-3">
    <div class="col-12 col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Products</div>
          <div class="fs-3 fw-semibold"><?= $stats['products'] ?></div>
          <a href="products.php" class="btn btn-sm btn-outline-primary mt-2">Manage Products</a>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Low Stock Alerts</div>
          <div class="fs-3 fw-semibold"><?= $stats['low_stock'] ?></div>
          <a href="stock_summary.php" class="btn btn-sm btn-outline-warning mt-2">View Stock Summary</a>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-muted small">Deliveries</div>
          <div class="fs-3 fw-semibold"><?= array_sum(array_map(fn($x)=>(int)$x['cnt'],$deliveryCounts ?: [])) ?></div>
          <a href="deliveries.php" class="btn btn-sm btn-outline-success mt-2">Manage Deliveries</a>
        </div>
      </div>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <h6 class="mb-3">Deliveries by Status</h6>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead>
            <tr>
              <th>Status</th>
              <th class="text-end">Count</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!$deliveryCounts): ?>
              <tr><td colspan="2" class="text-muted">No deliveries yet.</td></tr>
            <?php else: ?>
              <?php foreach ($deliveryCounts as $d): ?>
                <tr>
                  <td><span class="badge text-bg-secondary"><?= htmlspecialchars($d['status']) ?></span></td>
                  <td class="text-end fw-semibold"><?= (int)$d['cnt'] ?></td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</main>

<?php require_once __DIR__ . '/../templates/footer.php'; ?>
