# IMS Delivery Tracker (Inventory Management System + Delivery Tracking)

An Inventory Management System with Delivery Tracker and Geo Mapping built using **PHP + MySQL + Bootstrap + JavaScript**.

## Features

### Authentication & Roles
- Login system with session-based auth
- Roles:
  - **Admin**
  - **Staff**
  - **Driver**

### Inventory
- Products CRUD
- Product categories
- Suppliers CRUD
- Stock movements:
  - Stock IN
  - Stock OUT
  - Adjust stock
- Product stock history
- Low-stock highlighting (reorder level)

### Deliveries
- Customers CRUD
- Deliveries CRUD (create, assign, status updates)
- Delivery items (add products to a delivery)
- Delivery status workflow:
  - PENDING → ASSIGNED → PICKED_UP → IN_TRANSIT → DELIVERED (or CANCELLED)

### Driver Tracking
- Driver app page for assigned deliveries
- Sends GPS location updates periodically
- Staff/Admin live map viewer (latest driver location per delivery)
- Driver status update API

### Audit Logs
- Records key actions (create/update/delete/status changes, etc.)
- Search + filters + pagination
- View details per log

### Reports
- Inventory summary + low stock count
- Deliveries breakdown by status
- Monthly deliveries chart
- Profit summary (OUT movements × cost/sell price)
- Monthly profit chart
- Export reports to:
  - CSV
  - PDF

---

## Tech Stack
- PHP (procedural + PDO)
- MySQL / MariaDB
- Bootstrap 5
- JavaScript (Fetch API + Geolocation)
- Chart.js (reports)
- Dompdf (PDF export)

---

## Folder Structure (example)

> Update this section once you confirm final structure.

