<?php
// api/customer_get.php
require_once __DIR__ . '/../helpers/auth.php';
require_role(['admin', 'staff']);

header('Content-Type: application/json');

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

if ($id <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'Invalid customer id']);
    exit;
}

$stmt = $pdo->prepare("SELECT id, name, phone, email, address FROM customers WHERE id = :id LIMIT 1");
$stmt->execute([':id' => $id]);
$c = $stmt->fetch();

if (!$c) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Customer not found']);
    exit;
}

echo json_encode(['ok' => true, 'customer' => $c]);
