<?php
// api/driver_delivery_info.php
require_once __DIR__ . '/../helpers/auth.php';
require_role(['driver']);

header('Content-Type: application/json');

try {
    $pdo = db();
    $user = current_user();

    $delivery_id = (int)($_GET['delivery_id'] ?? 0);
    if ($delivery_id <= 0) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'Invalid delivery_id']);
        exit;
    }

    // Assigned check
    $stmt = $pdo->prepare("
      SELECT id, delivery_code, status, pickup_address, dropoff_address, scheduled_at, picked_up_at, delivered_at
      FROM deliveries
      WHERE id = :id AND assigned_driver_id = :uid
      LIMIT 1
    ");
    $stmt->execute([':id' => $delivery_id, ':uid' => (int)$user['id']]);
    $delivery = $stmt->fetch();

    if (!$delivery) {
        http_response_code(404);
        echo json_encode(['ok' => false, 'error' => 'Delivery not found or not assigned to you']);
        exit;
    }

    // ✅ Detect which column exists: quantity or qty
    $colStmt = $pdo->query("SHOW COLUMNS FROM delivery_items");
    $cols = $colStmt->fetchAll(PDO::FETCH_COLUMN, 0);
    $qtyCol = in_array('quantity', $cols, true) ? 'quantity' : (in_array('qty', $cols, true) ? 'qty' : null);

    if ($qtyCol === null) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => "delivery_items table must have 'quantity' or 'qty' column"]);
        exit;
    }

    // Delivery items
    $itemStmt = $pdo->prepare("
      SELECT
        di.product_id,
        di.$qtyCol AS quantity,
        p.sku,
        p.name,
        p.unit
      FROM delivery_items di
      JOIN products p ON p.id = di.product_id
      WHERE di.delivery_id = :did
      ORDER BY p.name ASC
    ");
    $itemStmt->execute([':did' => $delivery_id]);
    $items = $itemStmt->fetchAll();

    // Latest GPS saved
    $gps = $pdo->prepare("
      SELECT lat, lng, recorded_at
      FROM delivery_locations
      WHERE delivery_id = :did AND driver_id = :uid
      ORDER BY recorded_at DESC
      LIMIT 1
    ");
    $gps->execute([':did' => $delivery_id, ':uid' => (int)$user['id']]);
    $loc = $gps->fetch();

    echo json_encode([
        'ok' => true,
        'delivery' => [
            'id' => (int)$delivery['id'],
            'delivery_code' => $delivery['delivery_code'],
            'status' => $delivery['status'],
            'pickup_address' => $delivery['pickup_address'],
            'dropoff_address' => $delivery['dropoff_address'],
            'scheduled_at' => $delivery['scheduled_at'],
            'picked_up_at' => $delivery['picked_up_at'],
            'delivered_at' => $delivery['delivered_at'],
        ],
        'items' => array_map(function($r) {
            return [
                'product_id' => (int)$r['product_id'],
                'sku' => (string)$r['sku'],
                'name' => (string)$r['name'],
                'unit' => (string)$r['unit'],
                'quantity' => (int)$r['quantity'],
            ];
        }, $items),
        'last_gps' => $loc ? [
            'lat' => (float)$loc['lat'],
            'lng' => (float)$loc['lng'],
            'recorded_at' => $loc['recorded_at'],
        ] : null
    ]);
    exit;

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
    exit;
}
