<?php
// public/dashboard.php
require_once __DIR__ . '/../helpers/auth.php';
require_login();

$user = current_user();
$title = "Dashboard - IMS";

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/sidebar.php';
?>

<main class="col-12 col-md-9 col-lg-10 p-3 p-md-4">
  <div class="card shadow-sm">
    <div class="card-body">
      <h4 class="mb-1">Welcome, <?= htmlspecialchars($user['full_name']) ?></h4>
      <div class="text-muted">Role: <?= htmlspecialchars($user['role_name']) ?></div>

      <hr>

      <div class="row g-3">
        <div class="col-12 col-md-4">
          <div class="border rounded p-3 bg-white">
            <div class="fw-semibold">Products</div>
            <div class="text-muted small">Manage items & stock</div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="border rounded p-3 bg-white">
            <div class="fw-semibold">Deliveries</div>
            <div class="text-muted small">Track orders & drivers</div>
          </div>
        </div>
        <div class="col-12 col-md-4">
          <div class="border rounded p-3 bg-white">
            <div class="fw-semibold">Reports</div>
            <div class="text-muted small">Inventory & delivery summaries</div>
          </div>
        </div>
      </div>

      <div class="alert alert-info mt-3 mb-0">
        
      </div>
    </div>
  </div>
</main>

<?php require_once __DIR__ . '/../templates/footer.php'; ?>
